/*
 * backupswitch.m
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <devin at shiftedbits dot org> (Devin Lane) wrote this file. 
 * As long as you retain this notice you can do whatever you want with this
 * stuff. If we meet some day, and you think this stuff is worth it, you can
 * buy me a beer in return.
 *
 * Version 1.0:
 *		- Initial release
 */

#import <Foundation/Foundation.h>
#import <sys/xattr.h>

int main (int argc, const char * argv[]) {
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
	
	if (argc != 3) {
		fprintf(stderr, "Usage: backupswitch </Volumes/Backup/Backups.backupdb/computer> <00:00:00:00:00:00>\n");
		exit(1);
	} else if (getuid() != 0) {
		fprintf(stderr, "backupswitch must be run as root\n");
		exit(1);
	} else {
		const char *attrName = "com.apple.backupd.BackupMachineAddress";
		NSArray *baseArgs = [NSArray arrayWithObjects:@"-p", [NSString stringWithUTF8String:argv[1]], nil];
		
		/* Check to make sure the old acl exists */
		char oldValue[20];
		if (getxattr(argv[1], attrName, oldValue, 20, 0, 0) == 0) {
			fprintf(stderr, "This folder does not have a com.apple.backupd.BackupMachineAddress xattr!\n");
			exit(1);
		}
		
		printf("Previous MAC Address: %s\n", oldValue);
		
		/* Disable the acls protecting the backup folder */
		[[NSTask launchedTaskWithLaunchPath:@"/usr/sbin/fsaclctl" 
								  arguments:[baseArgs arrayByAddingObject:@"-d"]] waitUntilExit];
		
		if (setxattr(argv[1], attrName, argv[2], strlen(argv[2]) + 1, 0, 0) != 0) {
			fprintf(stderr, "Could not set xattr!\n");
		}
		
		/* Disable the acls protecting the backup folder */
		[[NSTask launchedTaskWithLaunchPath:@"/usr/sbin/fsaclctl" 
								  arguments:[baseArgs arrayByAddingObject:@"-e"]] waitUntilExit];
	}
	
    [pool drain];
    return 0;
}
