/*
 * TransparencyLayerView.m
 * 
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <devin at shiftedbits dot org> (Devin Lane) wrote this file. As long as you retain this notice you can do whatever you want with this stuff. 
 * If we meet some day, and you think this stuff is worth it, you can buy me a beer in return.
 */

#import "TransparencyLayerView.h"

@implementation TransparencyLayerView

- (void)awakeFromNib
{
	/* Refresh 4 times a second */
	[[NSTimer scheduledTimerWithTimeInterval:1/4.0 target:self selector:@selector(refreshEllipse) userInfo:nil repeats:YES] retain];
}

- (void)refreshEllipse
{
	[self setNeedsDisplay:YES];
}

- (BOOL)isOpaque
{
	return YES;
}

- (BOOL)acceptsFirstResponder
{
	return YES;
}

- (void)keyDown:(NSEvent *)theEvent
{
	if ([[theEvent charactersIgnoringModifiers] caseInsensitiveCompare:@"c"] == 0) {
		doClear = YES;
	}
}

- (void)drawRect:(NSRect)rect
{
	NSRect bounds = [self bounds];
	CGRect b = *(CGRect *)&bounds;
	CGRect ellipseRect = CGRectMake(-50, -50, 100, 100);
	
	CGContextRef context = [[NSGraphicsContext currentContext] graphicsPort];
	
	/* Don't fill the background as this makes it difficult to 
	 * see the effects of clipping the transparency layer.
	 * Unless the user has requested a clear, that is */
	if (doClear) {
		CGContextSetRGBFillColor(context, 1, 1, 1, 1);
		CGContextFillRect(context, b);
		doClear = NO;
	}
	
	/* The shadow will apply to the entire transparency layer */
	CGContextSetRGBFillColor(context, 0, 0, 0, 1);
	CGContextSetShadow(context, CGSizeMake(10, 10), 5);
	
	/* Begin a transparenty layer and draw two circles */
	CGContextBeginTransparencyLayer(context, NULL);
	CGContextTranslateCTM(context, b.size.width / 2, b.size.height / 2);
	CGContextBeginPath(context);
	CGContextAddEllipseInRect(context, CGRectOffset(ellipseRect, -25, 0));
	CGContextSetRGBFillColor(context, 1, 0, 0, 1);
	CGContextFillPath(context);
	CGContextBeginPath(context);
	CGContextAddEllipseInRect(context, CGRectOffset(ellipseRect, 25, 0));
	CGContextSetRGBFillColor(context, 0, 1, 0, 0.5f);
	CGContextFillPath(context);
	CGContextEndTransparencyLayer(context);
}

@end

@implementation ClippingTransparencyLayerView

- (void)drawRect:(NSRect)rect
{
	NSRect bounds = [self bounds];
	CGRect b = *(CGRect *)&bounds;
	CGRect ellipseRect = CGRectMake(-50, -50, 100, 100);
	
	CGContextRef context = [[NSGraphicsContext currentContext] graphicsPort];
	
	/* Don't fill the background as this makes it difficult to 
	 * see the effects of clipping the transparency layer.
	 * Unless the user has requested a clear, that is */
	if (doClear) {
		CGContextSetRGBFillColor(context, 1, 1, 1, 1);
		CGContextFillRect(context, b);
		doClear = NO;
	}
	
	/* Apply a shadow to the transparency layer */
	CGContextSetRGBFillColor(context, 0, 0, 0, 1);
	CGContextSetShadow(context, CGSizeMake(10, 10), 5);
	
	/* Clip the transparency layer to just larger than the two circles */
	CGContextClipToRect(context, CGRectMake(b.size.width/2-75, b.size.height/2-50, 175, 125));
	
	/* Draw two circles in the transparency layer */
	CGContextBeginTransparencyLayer(context, NULL);
	CGContextTranslateCTM(context,b.size.width / 2, b.size.height / 2);
	CGContextBeginPath(context);	
	CGContextAddEllipseInRect(context, CGRectOffset(ellipseRect, -25, 0));
	CGContextSetRGBFillColor(context, 1, 0, 0, 1);
	CGContextFillPath(context);
	CGContextBeginPath(context);
	CGContextAddEllipseInRect(context, CGRectOffset(ellipseRect, 25, 0));
	CGContextSetRGBFillColor(context, 0, 1, 0, 0.5f);
	CGContextFillPath(context);
	CGContextEndTransparencyLayer(context);
}

@end
